<?php
	
	defined('BASEPATH') or exit('No direct script access allowed');
	
	include_once(__DIR__ . '/App_pdf.php');
	
	class Proforma_pdf extends App_pdf
	{
		protected $proforma;
		
		private $proforma_number;
		
		public function __construct($proforma, $tag = '')
		{
			
			$proforma                = hooks()->apply_filters('proforma_html_pdf_data', $proforma);
			$GLOBALS['proforma_pdf'] = $proforma;
			
			parent::__construct();
			
			if (!class_exists('Invoices_model', false)) {
				$this->ci->load->model('proformas_model');
			}
			
			$this->tag            = $tag;
			$this->proforma        = $proforma;
			$this->proforma_number = format_proforma_number($this->proforma->id);
			$this->load_language($this->proforma->clientid);
			$this->SetTitle($this->proforma_number);
		}
		
		public function prepare()
		{
			$this->with_number_to_word($this->proforma->clientid);
			
			$this->set_view_vars([
				'status'         => $this->proforma->status,
				'proforma_number' => $this->proforma_number,
				'payment_modes'  => $this->get_payment_modes(),
				'proforma'        => $this->proforma,
			]);
			
			return $this->build();
		}
		
		protected function type()
		{
			return 'proforma';
		}
		
		protected function file_path()
		{
			$customPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/my_proformapdf.php';
			$actualPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/proformapdf.php';
			
			if (file_exists($customPath)) {
				$actualPath = $customPath;
			}
			
			return $actualPath;
		}
		
		private function get_payment_modes()
		{
			$this->ci->load->model('payment_modes_model');
			$payment_modes = $this->ci->payment_modes_model->get();
			
			// In case user want to include {proforma_number} or {client_id} in PDF offline mode description
			foreach ($payment_modes as $key => $mode) {
				if (isset($mode['description'])) {
					$payment_modes[$key]['description'] = str_replace('{proforma_number}', $this->proforma_number, $mode['description']);
					$payment_modes[$key]['description'] = str_replace('{client_id}', $this->proforma->clientid, $mode['description']);
				}
			}
			
			return $payment_modes;
		}
	}
